/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.frame;

import com.ibm.hsc.auiml.databeans.frame.PIFramePropertiesBean;
import com.ibm.hsc.client.PICageInfoDataBean;
import com.ibm.hsc.client.PIFrameDataBean;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.common.util.ErrorPanel;
import com.ibm.hsc.common.util.HscEAccess;
import com.ibm.hsc.websm.common.PIFrameUtils;
import com.ibm.hsc.websm.frame.CSPStateText;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskManagerException;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.ArrayList;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;

public class PIFramePropertiesDialog
implements TaskActionListener {
    private static final String AUIML_CLASS_NAME = "com.ibm.hsc.auiml.databeans.frame.PIFrameProperties";
    private static final String AUIML_PANEL = "FramePropertyTabbedPane";
    private MOXContainerObj m_MOXObj;
    private MOClass m_MOClass;
    private String m_hostName;
    private String m_nameSpace;
    private String m_frameID;
    private Integer m_state;
    private UserTaskManager m_utm = null;
    private PIFramePropertiesBean m_frameBean = null;
    private PICageInfoDataBean[] m_cimCageBeans = null;
    private Hashtable m_frameCageInfo = null;
    private PIFrameDataBean m_cimFrameBean = null;

    public PIFramePropertiesDialog(MOXContainerObj mOXContainerObj) {
        this.m_MOXObj = mOXContainerObj;
        this.m_MOClass = mOXContainerObj.getMOClass();
        this.m_hostName = mOXContainerObj.getHost().getName();
        this.m_frameID = mOXContainerObj.getKey();
        this.m_nameSpace = (String)mOXContainerObj.getPropertyValue("nameSpace_Prop");
        this.m_state = (Integer)mOXContainerObj.getPropertyValue("state_PROP");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showDialog() {
        AuimlAdapter auimlAdapter = null;
        Exception exception = null;
        this.m_frameBean = new PIFramePropertiesBean();
        this.m_frameBean.load();
        String string = "";
        try {
            Object[] objectArray = new Object[]{this.m_MOXObj};
            try {
                this.m_cimFrameBean = (PIFrameDataBean)this.m_MOClass.invokeStaticMethod("getFrameDataBean", objectArray);
                if (this.m_cimFrameBean == null) {
                    throw new Exception();
                }
            }
            catch (Exception exception2) {
                this.debug("*** Exception: cannot get frame data");
                exception2.printStackTrace();
                string = "frameError";
                throw exception2;
            }
            try {
                this.m_cimCageBeans = (PICageInfoDataBean[])this.m_MOClass.invokeStaticMethod("getFrameCageInfo", objectArray);
                if (this.m_cimCageBeans == null) {
                    throw new Exception();
                }
                this.m_frameCageInfo = PIFrameUtils.sortCages(this.m_cimCageBeans);
                System.err.println("m_frameCageInfo is : " + this.m_frameCageInfo);
            }
            catch (Exception exception3) {
                this.debug("*** Exception: cannot get frame cage info");
                exception3.printStackTrace();
                exception = exception3;
            }
            DataBean[] dataBeanArray = new DataBean[]{this.m_frameBean};
            auimlAdapter = new AuimlAdapter(AUIML_CLASS_NAME, AUIML_PANEL, dataBeanArray);
            this.m_utm = auimlAdapter.getUserTaskManager();
            this.loadFrameBean();
            this.m_frameBean.setUTM(this.m_utm);
            String string2 = "Frame Properties : " + this.m_frameID + "@" + this.m_hostName;
            this.m_utm.setCaptionText(AUIML_PANEL, string2);
            this.m_utm.addCommitListener((TaskActionListener)this);
            auimlAdapter.showIt();
            if (exception == null) return;
        }
        catch (TaskManagerException taskManagerException) {
            this.debug("*** Exception: user task manager exception");
            taskManagerException.printStackTrace();
            String string3 = "Error: Cannot launch Frame Properties";
            String string4 = taskManagerException.getMessage();
            String string5 = "Panel Error";
            ErrorPanel errorPanel = new ErrorPanel(string4, string3, string5);
            errorPanel.show();
            return;
        }
        catch (Exception exception4) {
            if (string.equals("frameError")) {
                String string6 = "Error: Cannot get Frame Info";
                String string7 = exception4.getMessage();
                String string8 = "CIM Error";
                ErrorPanel errorPanel = new ErrorPanel(string7, string6, string8);
                errorPanel.show();
            }
            System.err.println("Frame Props Error...");
            exception4.printStackTrace();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void loadFrameBean() {
        this.debug("->loadFrameBean");
        this.debug("-> Frame Bean >>>" + this.m_cimFrameBean.toString());
        if (this.m_cimFrameBean.getUserDefinedName() != null) {
            this.m_frameBean.setName(this.m_cimFrameBean.getUserDefinedName());
        }
        if (this.m_cimFrameBean.getFrameNumber() != null) {
            this.m_frameBean.setNumber(this.m_cimFrameBean.getFrameNumber().intValue());
        }
        if (this.m_state != null) {
            int n = this.m_state;
            this.m_frameBean.setState(CSPStateText.getStateValue(n));
            if (n != 8195) {
                this.debug("Not both in standby state: DISABLING frame number fields");
                this.m_utm.setEnabled("GeneralPanel.FrmNum", false);
            }
            if (n != 8195 && n != 8193 && n != 8194) {
                this.debug("Not in standby state: DISABLING frame name fields");
                this.m_utm.setEnabled("GeneralPanel.FrmName", false);
            }
        }
        String string = this.m_cimFrameBean.getInternalName();
        this.debug(": internal name " + string);
        if (string != null && string.indexOf("*") != -1) {
            this.m_frameBean.setType(string.substring(0, string.indexOf("*")));
            this.m_frameBean.setSerialNumber(string.substring(string.indexOf("*") + 1));
        }
        if (this.m_frameCageInfo != null) {
            this.loadCecCageInfo();
            this.loadIOCageInfo();
        }
        this.debug("->end loadFrameBean");
    }

    public void loadCecCageInfo() {
        this.debug("->loadCecCageInfo");
        PICageInfoDataBean pICageInfoDataBean = null;
        System.err.println("m_frameCageInfo is : " + this.m_frameCageInfo);
        ArrayList arrayList = (ArrayList)this.m_frameCageInfo.get("CecCages");
        ArrayList arrayList2 = (ArrayList)this.m_frameCageInfo.get("BpaCages");
        ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[arrayList.size() + arrayList2.size()];
        ItemDescriptor[] itemDescriptorArray2 = new ItemDescriptor[arrayList.size() + arrayList2.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.debug("ndx = " + i);
            pICageInfoDataBean = (PICageInfoDataBean)arrayList.get(i);
            String string = pICageInfoDataBean.getCageName();
            if (string != null) {
                string = string.substring(0, string.indexOf("*"));
            }
            itemDescriptorArray[i] = new ItemDescriptor("cecCage" + i, string);
            itemDescriptorArray2[i] = new ItemDescriptor("cecSys" + i, pICageInfoDataBean.getCageMtms());
        }
        for (int i = i; i < arrayList.size() + arrayList2.size(); ++i) {
            this.debug("i = " + i);
            pICageInfoDataBean = (PICageInfoDataBean)arrayList2.get(i - arrayList.size());
            String string = pICageInfoDataBean.getCageName();
            if (string != null) {
                string = string.substring(0, string.indexOf("*"));
            }
            itemDescriptorArray[i] = new ItemDescriptor("cecCage" + i, string);
            itemDescriptorArray2[i] = new ItemDescriptor("cecSys" + i, pICageInfoDataBean.getCageMtms());
        }
        this.m_frameBean.setSysCageList(itemDescriptorArray);
        this.m_frameBean.setSysSystemList(itemDescriptorArray2);
    }

    public void loadIOCageInfo() {
        this.debug("->loadIOCageInfo");
        PICageInfoDataBean pICageInfoDataBean = null;
        ArrayList arrayList = (ArrayList)this.m_frameCageInfo.get("IoCages");
        ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[arrayList.size()];
        ItemDescriptor[] itemDescriptorArray2 = new ItemDescriptor[arrayList.size()];
        ItemDescriptor[] itemDescriptorArray3 = new ItemDescriptor[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            pICageInfoDataBean = (PICageInfoDataBean)arrayList.get(i);
            System.err.println("PICageInfoBean: " + pICageInfoDataBean);
            itemDescriptorArray[i] = new ItemDescriptor("ioCode" + i, pICageInfoDataBean.getLocCode());
            String string = pICageInfoDataBean.getCageName();
            if (string != null) {
                string = string.substring(0, string.indexOf("*"));
            }
            itemDescriptorArray2[i] = new ItemDescriptor("ioCage" + i, string);
            String string2 = pICageInfoDataBean.getOwnerMtms();
            string2 = string2 == null ? "Not owned" : string2;
            itemDescriptorArray3[i] = new ItemDescriptor("ioSys" + i, string2);
        }
        this.m_frameBean.setIOLocCodeList(itemDescriptorArray);
        this.m_frameBean.setIOCageList(itemDescriptorArray2);
        this.m_frameBean.setIOSystemList(itemDescriptorArray3);
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        this.debug("->actionPerformed: " + taskActionEvent.getActionCommand() + " " + taskActionEvent.getCurrentElement() + " " + taskActionEvent.getElementName());
        this.debug("->actionPerformed: " + taskActionEvent);
        try {
            if (!HscEAccess.checkAccess("FrameMObjActDispInfo", "FrameModify", this.m_MOXObj.getMOClass().getHost().getName())) {
                return;
            }
        }
        catch (Exception exception) {
            this.debug("-actionPerformed: ");
            exception.printStackTrace();
        }
        if (this.isModified()) {
            Object[] objectArray;
            this.debug(": setting frame bean");
            int n = this.m_frameBean.getNumber();
            if (n > 65535 || n < 0) {
                objectArray = "Frame Number must be greater than or equal to 0 and less than 65536";
                String string = "Error";
                String string2 = "User input error";
                ErrorPanel errorPanel = new ErrorPanel((String)objectArray, string, string2, this.m_utm);
                errorPanel.show();
            }
            try {
                objectArray = new Object[]{this.m_MOXObj, this.m_cimFrameBean};
                this.m_MOClass.invokeStaticMethod("setFrameBean", objectArray);
            }
            catch (Exception exception) {
                this.debug("***Exception in commit listener: FrameMObject->setFrameDataBean failed.");
                exception.printStackTrace();
            }
        }
    }

    private boolean isModified() {
        this.debug("->isModified");
        boolean bl = false;
        String string = this.m_frameBean.getName();
        int n = this.m_frameBean.getNumber();
        if (!string.equals(this.m_cimFrameBean.getUserDefinedName())) {
            this.debug("name = " + string + " oldName = " + this.m_cimFrameBean.getUserDefinedName());
            this.m_cimFrameBean.setUserDefinedName(string);
            bl = true;
        }
        this.debug(": here");
        if (n != this.m_cimFrameBean.getFrameNumber().intValue()) {
            this.debug("number = " + n + " oldNumber = " + this.m_cimFrameBean.getFrameNumber());
            this.m_cimFrameBean.setFrameNumber(new UnsignedInt16(n));
            bl = true;
        }
        this.debug(": here");
        return bl;
    }

    private void debug(String string) {
        System.err.println("PIFramePropertiesDialog" + string);
    }
}

